import openmatrix as omx
import openpyxl
import numpy as np
import csv
import sys

#Apertura del file OMX
OMXfile = omx.open_file('IMQ2013_zonecampionarie.omx')
print("File OMX di riferimento: ",OMXfile.filename,"\n")

#Caricamento delle informazioni sulla mappatura (per conversione cod. alfanumerico - cod. numerico)
excel_document = openpyxl.load_workbook('ZoneCampionarie2013.xlsx') 
nsheet = excel_document.sheetnames  
sheet = excel_document[nsheet[0]] 
zoneA = list()   
zoneN = np.zeros(209)
for j in range(0,209):
    zoneA.append(sheet.cell(row=j+2,column=2).value)
    zoneN[j] = sheet.cell(row=j+2,column=1).value    

#Ottemimento dei dati di ingresso 
zona = input("Inserire codice zona: ")
modo = input("Inserire il modo (Pr-privato, Pu-Pubblico, T-totali): ")
per = input("Periodo (IG-intera giornata, OP-ora di punta): ")
if per == "IG":
    scopo = input("Scopo (t-tutti, sr-tutti escluso ritorno): ")
else: 
    scopo = 't'

#Apretura del file di scrittura dei risultati
fileOUT = open('SpostProd_PRV.csv','wt')
writer = csv.writer(fileOUT)
writer.writerow(('COD_ZONA','SPOSTAMENTI','coord_X','coord_Y'))

##Determinazione del flusso prodotto/attratto
FProd = 0
FAttr = 0
if modo == "T":
    for md in ['Pu','Pr']:
        for i in range(0,209):
            FProd = FProd + OMXfile['ResPIEm'+md+per+scopo][zoneA.index(zona)][i]
            FAttr = FAttr + OMXfile['ResPIEm'+md+per+scopo][i][zoneA.index(zona)]
    #Stampa a video dei risultati            
    print("\nSPOSTAMENTI TOTALI IN USCITA: ",FProd)
    print("SPOSTAMENTI TOTALI IN ENTRATA: ",FAttr)
    print("Matrici di riferimento: ","ResPIEmPu"+per+scopo,"/ ResPIEmPr"+per+scopo)    
    #Stampa su file dei risultati
    for i in range(0,208):
        cod = sheet.cell(row=i+2,column=2).value
        spost = OMXfile['ResPIEmPu'+per+scopo][zoneA.index(zona)][i]+OMXfile['ResPIEmPr'+per+scopo][zoneA.index(zona)][i]
        cX = sheet.cell(row=i+2,column=7).value
        cY = sheet.cell(row=i+2,column=8).value
        writer.writerow((cod,spost,cX,cY))    
else:
    for i in range(0,209):
        FProd = FProd + OMXfile['ResPIEm'+modo+per+scopo][zoneA.index(zona)][i]
        FAttr = FAttr + OMXfile['ResPIEm'+modo+per+scopo][i][zoneA.index(zona)]
    #Stampa a video dei risultati
    print("\nSPOSTAMENTI TOTALI IN USCITA: \t",FProd)
    print("SPOSTAMENTI TOTALI IN ENTRATA: \t",FAttr)
    print("Matrici di riferimento: ","ResPIEm"+modo+per+scopo)    
    #Stampa su file dei risultati
    for i in range(0,208):
        cod = sheet.cell(row=i+2,column=2).value
        spost = str(OMXfile['ResPIEm'+modo+per+scopo][zoneA.index(zona)][i])
        cX = str(sheet.cell(row=i+2,column=7).value)
        cY = str(sheet.cell(row=i+2,column=8).value)
        writer.writerow((cod,spost,cX,cY))

#Chiusura dei file aperti
fileOUT.close()
OMXfile.close()

